#ifndef _DIALOGS_MAIN_H
#define _DIALOGS_MAIN_H
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK MainDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    //--------------------------------------------------------------------------

    static HMENU SystemMenu = NULL;

    //--------------------------------------------------------------------------

    if(xMessage == WM_INITDIALOG) // Received A Initilize Dialog Message
    {
        gbIsClientDialogOpen = true;

        SystemMenu = GetSystemMenu(xHandle, FALSE);
        AppendMenu(SystemMenu, MF_SEPARATOR, 0, 0);
        AppendMenu(SystemMenu, MF_STRING, 1001, "Version");

        MainDialog_hWnd = xHandle;

        SendMessage(xHandle, (UINT)WM_SETTEXT, (WPARAM)0, (LPARAM)TitleCaption);
        SendMessage(xHandle, WM_SETICON, TRUE, (LPARAM) LoadIcon(MainInstance, MAKEINTRESOURCE(IDI_MAIN)) );

        MDI.RecvEdit_hWnd = GetDlgItem(xHandle, IDC_RECVLIST);

        RECT WindowRECT;
        GetClientRect(xHandle, &WindowRECT);
        MoveWindow(MDI.RecvEdit_hWnd, 0, 0, WindowRECT.right, WindowRECT.bottom, TRUE);

        CenterWindow(xHandle);

        DialogBox(MainInstance, MAKEINTRESOURCE(IDD_SPLASH), xHandle, SplashDialog);

        return TRUE; // Return TRUE to set the keyboard focus, Otherwise return FALSE
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_SIZE)
    {
        int nWidth = LOWORD(lParam);
        int nHeight = HIWORD(lParam);
        MoveWindow(MDI.RecvEdit_hWnd, 0, 0, nWidth, nHeight, TRUE);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_CTLCOLORSTATIC)
	{
		if((HANDLE)lParam == MDI.RecvEdit_hWnd)
            return Set_Color(RGB(0, 0, 0), RGB(255, 255, 255), wParam);

        return FALSE;
    }

    if(xMessage == WM_COMMAND)
    {
        if(wParam == ID_CONNECTION_CONNECTNOW)
        {
            gbConnectNow = true;
            return TRUE;
        }

        if(wParam == ID_CONNECTION_FORCEDISCONNECT)
        {
            if(MessageBox(xHandle, "Disconnecting during an active session may result in data loss.\r\nAre you sure you want to forcfully disconnect from the server?", TitleCaption, MB_YESNO|MB_APPLMODAL) == IDYES)
            {
                MyClient.DisconnectClient();
                return 0;
            }

            return TRUE;
        }

        if(wParam == ID_SETTINGS_GENERALSETTINGS)
		{
            PROPSHEETPAGE   psp[4];
            PROPSHEETHEADER psh;

            memset(&psp[0], '\0', sizeof(PROPSHEETPAGE));
            psp[0].dwSize      = sizeof(PROPSHEETPAGE);
            psp[0].dwFlags     = PSP_DEFAULT|PSP_USETITLE;
            psp[0].hInstance   = MainInstance;
            psp[0].pszTemplate = MAKEINTRESOURCE(IDD_GENERALTAB);
            psp[0].pszIcon     = NULL;
            psp[0].pszTitle    = "General";
            psp[0].pfnDlgProc  = TabGeneralDialog;
            psp[0].lParam      = 0;
            psp[0].pfnCallback = NULL;
            psp[0].pcRefParent = NULL;

            memset(&psp[1], '\0', sizeof(PROPSHEETPAGE));
            psp[1].dwSize      = sizeof(PROPSHEETPAGE);
            psp[1].dwFlags     = PSP_DEFAULT|PSP_USETITLE;
            psp[1].hInstance   = MainInstance;
            psp[1].pszTemplate = MAKEINTRESOURCE(IDD_SQLTAB);
            psp[1].pszIcon     = NULL;
            psp[1].pszTitle    = "SQL";
            psp[1].pfnDlgProc  = TabSQLDialog;
            psp[1].lParam      = 0;
            psp[1].pfnCallback = NULL;
            psp[1].pcRefParent = NULL;

            memset(&psp[2], '\0', sizeof(PROPSHEETPAGE));
            psp[2].dwSize      = sizeof(PROPSHEETPAGE);
            psp[2].dwFlags     = PSP_DEFAULT|PSP_USETITLE;
            psp[2].hInstance   = MainInstance;
            psp[2].pszTemplate = MAKEINTRESOURCE(IDD_SECURITYTAB);
            psp[2].pszIcon     = NULL;
            psp[2].pszTitle    = "Security";
            psp[2].pfnDlgProc  = TabSecurityDialog;
            psp[2].lParam      = 0;
            psp[2].pfnCallback = NULL;
            psp[2].pcRefParent = NULL;

            memset(&psp[3], '\0', sizeof(PROPSHEETPAGE));
            psp[3].dwSize      = sizeof(PROPSHEETPAGE);
            psp[3].dwFlags     = PSP_DEFAULT|PSP_USETITLE;
            psp[3].hInstance   = MainInstance;
            psp[3].pszTemplate = MAKEINTRESOURCE(IDD_ADVANCEDTAB);
            psp[3].pszIcon     = NULL;
            psp[3].pszTitle    = "Advanced";
            psp[3].pfnDlgProc  = TabAdvancedDialog;
            psp[3].lParam      = 0;
            psp[3].pfnCallback = NULL;
            psp[3].pcRefParent = NULL;

            memset(&psh, '\0', sizeof(PROPSHEETHEADER));
            psh.dwSize      = sizeof(PROPSHEETHEADER);
            psh.dwFlags     = PSH_USEHICON | PSH_PROPSHEETPAGE | PSH_NOAPPLYNOW;
            psh.hwndParent  = xHandle;
            psh.hInstance   = MainInstance;
            psh.hIcon       = LoadIcon(MainInstance, MAKEINTRESOURCE(IDI_MAINICON));
            psh.pszCaption  = "Client Settings";
            psh.nPages      = 4;
            psh.nStartPage  = 0;
            psh.ppsp        = (LPCPROPSHEETPAGE) &psp;
            psh.pfnCallback = NULL;

            PropertySheet(&psh);

            SaveRegistryValues();

            return TRUE;
        }

        return FALSE;
    }

    //--------------------------------------------------------------------------

	if(xMessage == WM_PAINT)
    {
        HDC ThisHDC;
        PAINTSTRUCT ThisPS;

        ThisHDC = BeginPaint(xHandle, &ThisPS);

        // Any painting should be done here

        EndPaint(xHandle, &ThisPS);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_CLOSE)  // Received Close Message
    {
        EndDialog(xHandle,0);
        DestroyWindow(xHandle);
        gbIsClientDialogOpen = false;
        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_SYSCOMMAND) // Received A System Menu Message
    {
        if(LOWORD(wParam) == 1001) //- Version (SysMenu Command)
        {
            char VersionText[128];
            sprintf(VersionText, "%s, Version %s \r\n Built on '%s' at '%s'", TitleCaption, FileVersion, __DATE__, __TIME__);
            MessageBox(xHandle, VersionText, "Application Version", MB_TASKMODAL);
            return TRUE;
        }
        return FALSE;
    }

    //--------------------------------------------------------------------------

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

